/**
 * @file    mg32_dbg.h
 * @author  MegawinTech Application Team
 * @brief   This file contains all the functions prototypes for the DBG firmware
 *          library.
 */

/* Define to prevent recursive inclusion -----------------------------------------------------------------------------*/
#ifndef __MG32_DBG_H
#define __MG32_DBG_H

#ifdef __cplusplus
extern "C" {
#endif

/* Files includes ----------------------------------------------------------------------------------------------------*/
#include "mg32f04p032_device.h"

/** @addtogroup MG32_StdPeriph_Driver
  * @{
  */

/** @defgroup DBG
  * @{
  */

/** @defgroup DBG_Exported_Types
  * @{
  */

/**
  * @}
  */

/** @defgroup DBG_Exported_Constants
  * @{
  */
/**
  * @brief DBG_CR Register Bit Definition
  */

#define DBGMCU_SLEEP                 (0x01U << DBGMCU_CR_SLEEP_Pos)          /*!< Debug Sleep mode */
#define DBGMCU_IWDG_STOP             (0x01U << DBGMCU_CR_IWDG_STOP_Pos)      /*!< Debug independent watchdog stopped when core is mg32ted */
#define DBGMCU_TIM1_STOP             (0x01U << DBGMCU_CR_TIM1_STOP_Pos)      /*!< TIM1 stops work when the core enters the debug mode */
#define DBGMCU_TIM2_STOP             (0x01U << DBGMCU_CR_TIM2_STOP_Pos)      /*!< TIM2 stops work when the core enters the debug mode */
#define DBGMCU_TIM1_PWM_OFF          (0x01U << DBGMCU_CR_TIM1_PWM_OFF_Pos)   /*!< TIM1 outputs all 0 at debug mg32t */
#define DBGMCU_TIM2_PWM_OFF          (0x01U << DBGMCU_CR_TIM2_PWM_OFF_Pos)   /*!< TIM2 outputs all 0 at debug mg32t */
#define DBGMCU_TIM14_STOP            (0x01U << DBGMCU_CR_TIM14_STOP_Pos)     /*!< TIM14 stops work when the core enters the debug mode */
#define DBGMCU_TIM13_STOP            (0x01U << DBGMCU_CR_TIM13_STOP_Pos)     /*!< TIM13 stops work when the core enters the debug mode */
#define DBGMCU_TIM6_STOP             (0x01U << DBGMCU_CR_TIM6_STOP_Pos)      /*!< TIM6 stops work when the core enters the debug mode */

/**
  * @}
  */

/** @defgroup DBG_Exported_Functions
  * @{
  */
void DBGMCU_Configure(uint32_t periph, FunctionalState state);
uint32_t DBGMCU_GetDeviceIDCode(void);

#endif

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
